function plotCluster( data, labs, path )
%PLOTCLASSIFIER Summary of this function goes here
%   Detailed explanation goes here

% produces a cluster plot of data with cluster labels: labs.
% path is the location of the output path for the LaTeX file source code.


s = size( labs );

figure
h = gcf();

plot( data( :, 1 ), data( :, 2 ), '*k' )

hold on

for i = 1:size( data, 1 )
    text( data( i, 1 ), data( i, 2 ), [ num2str( i ) ' ' ], ...
            'HorizontalAlignment','right')
end
for w = 1:s( 2 )
    
    

    u = unique( labs( :, w ) );
    %l = labs( :, w )
    for i = 1:numel( u )
       
        index = find( labs( :, w ) == u( i ) );
        n = numel( index );
        for j = 1:n
            for k = j:n
                
                switch w
                   
                   case 1
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], 'r' )
                       
                   case 2
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], '--g' )
                   case 3
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], '-.b' )
                   case 4
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], ':k' )
                   case 5
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], 'c' )
                   case 6
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], 'm' )
                   case 7
                       
                       plot( [ data( index( j ), 1 ) data( index( k ), 1 ) ], ...
                           [ data( index( j ), 2 ) data( index( k ), 2 ) ], 'y' )
                   otherwise
                       
                end
            end
        end
    end




end
hold off
saveas( h, [ path 'Figures/' num2str( h ) '.eps' ], 'psc2' )
saveas( h, [ path 'pngs/' num2str( h ) '.png' ], 'png' )

